import numpy as np
import torch
import torch.nn as nn
from torch.optim import Adam
import safety_gym
import gym
import time
import  core
from utils.logx import EpochLogger
from utils.mpi_pytorch import setup_pytorch_for_mpi, sync_params, mpi_avg_grads
from utils.mpi_tools import mpi_fork, mpi_avg, proc_id, mpi_statistics_scalar, num_procs, broadcast
Softplus=torch.nn.Softplus()
torch.autograd.set_detect_anomaly(True)
import sys
import sysv_ipc
import torch.optim as optim
import torch.nn.functional as F
import ignite.handlers.param_scheduler as IGN
import pandas as pd
import matplotlib.pyplot as plt
from torch.nn.utils import clip_grad_norm_
from mpi4py import MPI
import psutil
import os
import gc
import random
from torch.distributions.normal import Normal
class Safety_NN(nn.Module):
    def __init__(self, n_state, n_class):
        super(Safety_NN, self).__init__()
        self.layer1 = nn.Linear(n_state, 64) # add action dimension
        self.layer2 = nn.Linear(64, 64)
        # self.layer3 = nn.Linear(512, 512)
        # self.layer4 = nn.Linear(512, 512)
        # self.layer5 = nn.Linear(512, 512)
        # self.layer6 = nn.Linear(512, 512)
        #self.layer7 = nn.Linear(512, 128)
        self.layer8 = nn.Linear(64, n_class)
    def forward(self, x):
        x = F.relu(self.layer1(x))
        x = F.relu(self.layer2(x))
        # x = F.relu(self.layer3(x))
        # x = F.relu(self.layer4(x))
        # x = F.relu(self.layer5(x))
        # x = F.relu(self.layer6(x))
        # x = F.relu(self.layer7(x))
        return self.layer8(x)


class SHM : 
    def __init__( self ) : 
        pass
    def readMem( self , key, size) : 
        memory = sysv_ipc.SharedMemory(key=key)
        memory_value = memory.read()
        print ("I got:  ",memory_value.decode())
    def writeMem(self,key,size,text):
        shm = sysv_ipc.SharedMemory(key=key, flags=sysv_ipc.IPC_CREAT, mode=0o666, size=size)
        shm.write(text.encode())
        shm.detach()
        print("I sent: ", text,"\n")


class PPOBuffer:
    """
    A buffer for storing trajectories experienced by a PPO agent interacting
    with the environment, and using Generalized Advantage Estimation (GAE-Lambda)
    for calculating the advantages of state-action pairs.
    """

    def __init__(self, obs_dim, act_dim, size, gamma=0.99, lam=0.97):
        self.obs_buf = np.zeros(core.combined_shape(size, obs_dim), dtype=np.float32)
        self.act_buf = np.zeros(core.combined_shape(size, act_dim), dtype=np.float32)
        
        self.adv_buf = np.zeros(size, dtype=np.float32)
        self.cadv_buf = np.zeros(size, dtype=np.float32)

        self.rew_buf = np.zeros(size, dtype=np.float32)
        self.crew_buf = np.zeros(size, dtype=np.float32)

        self.ret_buf = np.zeros(size, dtype=np.float32)
        self.cret_buf = np.zeros(size, dtype=np.float32)

        self.val_buf = np.zeros(size, dtype=np.float32)
        self.cval_buf = np.zeros(size, dtype=np.float32)
        
        self.logp_buf = np.zeros(size, dtype=np.float32)
        self.gamma, self.lam = gamma, lam
        self.ptr, self.path_start_idx, self.max_size = 0, 0, size

        #buf.store(   o, a, r, c, v,vc, logp)
    def store(self, obs, act, rew, crew, val,cval, logp):
        """
        Append one timestep of agent-environment interaction to the buffer.
        """
        assert self.ptr < self.max_size     # buffer has to have room so you can store
        self.obs_buf[self.ptr] = obs
        self.act_buf[self.ptr] = act
        self.rew_buf[self.ptr] = rew
        self.crew_buf[self.ptr] = crew

        self.val_buf[self.ptr] = val
        self.cval_buf[self.ptr] = cval

        self.logp_buf[self.ptr] = logp
        self.ptr += 1

    def finish_path(self, last_val=0, last_cval=0):
        """
        Call this at the end of a trajectory, or when one gets cut off
        by an epoch ending. This looks back in the buffer to where the
        trajectory started, and uses rewards and value estimates from
        the whole trajectory to compute advantage estimates with GAE-Lambda,
        as well as compute the rewards-to-go for each state, to use as
        the targets for the value function.

        The "last_val" argument should be 0 if the trajectory ended
        because the agent reached a terminal state (died), and otherwise
        should be V(s_T), the value function estimated for the last state.
        This allows us to bootstrap the reward-to-go calculation to account
        for timesteps beyond the arbitrary episode horizon (or epoch cutoff).
        """

        path_slice = slice(self.path_start_idx, self.ptr)
        rews = np.append(self.rew_buf[path_slice], last_val)
        crews = np.append(self.crew_buf[path_slice], last_cval)

        vals = np.append(self.val_buf[path_slice], last_val)
        cvals = np.append(self.cval_buf[path_slice], last_cval)
        
        # the next two lines implement GAE-Lambda advantage calculation
        deltas = rews[:-1] + self.gamma * vals[1:] - vals[:-1]
        cdeltas = crews[:-1] + self.gamma * cvals[1:] - cvals[:-1]

        self.adv_buf[path_slice] = core.discount_cumsum(deltas, self.gamma * self.lam)
        self.cadv_buf[path_slice] = core.discount_cumsum(cdeltas, self.gamma * self.lam)

        
        # the next line computes rewards-to-go, to be targets for the value function
        self.ret_buf[path_slice] = core.discount_cumsum(rews, self.gamma)[:-1]
        self.cret_buf[path_slice] = core.discount_cumsum(crews, self.gamma)[:-1]
        
        self.path_start_idx = self.ptr

    def get(self):
        """
        Call this at the end of an epoch to get all of the data from
        the buffer, with advantages appropriately normalized (shifted to have
        mean zero and std one). Also, resets some pointers in the buffer.
        """
        assert self.ptr == self.max_size    # buffer has to be full before you can get
        self.ptr, self.path_start_idx = 0, 0
        # the next two lines implement the advantage normalization trick
        adv_mean, adv_std = mpi_statistics_scalar(self.adv_buf)
        cadv_mean, cadv_std = mpi_statistics_scalar(self.cadv_buf)

        self.adv_buf = (self.adv_buf - adv_mean) / adv_std
        self.cadv_buf = (self.cadv_buf - cadv_mean) #/ adv_std

        data = dict(obs=self.obs_buf, act=self.act_buf, crew=self.crew_buf, ret=self.ret_buf, cret=self.cret_buf,
                    adv=self.adv_buf, cadv=self.cadv_buf, logp=self.logp_buf)
        return {k: torch.as_tensor(v, dtype=torch.float32) for k,v in data.items()}


def ppo(env_fn, actor_critic=core.MLPActorCritic, ac_kwargs=dict(), seed=0, 
        steps_per_epoch=4000, epochs=50, gamma=0.99, clip_ratio=0.2, pi_lr=3e-5,
        vf_lr=1e-4, train_pi_iters=80, train_v_iters=80, lam=0.97, max_ep_len=1000,
        target_kl=0.01, logger_kwargs=dict(), save_freq=1000,
        render=False,
        n_NN = 1,
        # n_translation = 3,
        # n_rotation = 41,
        n_sample_of_action = 252, #@ 250105
        n_class = 2,
        n_action = 2,
        file_intest_number_array = [5000000, 5000000], 
        storage_intest_number_array = [5000000, 5000000],
        pof_section = 4,
        gradient_offset = True,
        batch_training = True,
        unit_intest_batch_size_array = [5000,5000],
        intest_trajectory_step = 60,
        default_action_margin = 0.05,
        pof_checkpoint = 1,
        pof_checkpoint_load_epoch =-1,
        hazard_check_margin = 0.935,
        ppo_checkpoint = "-1",
        cpu = -1
        ):
    """
    Proximal Policy Optimization (by clipping), 

    with early stopping based on approximate KL

    Args:
        env_fn : A function which creates a copy of the environment.
            The environment must satisfy the OpenAI Gym API.

        actor_critic: The constructor method for a PyTorch Module with a 
            ``step`` method, an ``act`` method, a ``pi`` module, and a ``v`` 
            module. The ``step`` method should accept a batch of observations 
            and return:

            ===========  ================  ======================================
            Symbol       Shape             Description
            ===========  ================  ======================================
            ``a``        (batch, act_dim)  | Numpy array of actions for each 
                                           | observation.
            ``v``        (batch,)          | Numpy array of value estimates
                                           | for the provided observations.
            ``logp_a``   (batch,)          | Numpy array of log probs for the
                                           | actions in ``a``.
            ===========  ================  ======================================

            The ``act`` method behaves the same as ``step`` but only returns ``a``.

            The ``pi`` module's forward call should accept a batch of 
            observations and optionally a batch of actions, and return:

            ===========  ================  ======================================
            Symbol       Shape             Description
            ===========  ================  ======================================
            ``pi``       N/A               | Torch Distribution object, containing
                                           | a batch of distributions describing
                                           | the policy for the provided observations.
            ``logp_a``   (batch,)          | Optional (only returned if batch of
                                           | actions is given). Tensor containing 
                                           | the log probability, according to 
                                           | the policy, of the provided actions.
                                           | If actions not given, will contain
                                           | ``None``.
            ===========  ================  ======================================

            The ``v`` module's forward call should accept a batch of observations
            and return:

            ===========  ================  ======================================
            Symbol       Shape             Description
            ===========  ================  ======================================
            ``v``        (batch,)          | Tensor containing the value estimates
                                           | for the provided observations. (Critical: 
                                           | make sure to flatten this!)
            ===========  ================  ======================================


        ac_kwargs (dict): Any kwargs appropriate for the ActorCritic object 
            you provided to PPO.

        seed (int): Seed for random number generators.

        steps_per_epoch (int): Number of steps of interaction (state-action pairs) 
            for the agent and the environment in each epoch.

        epochs (int): Number of epochs of interaction (equivalent to
            number of policy updates) to perform.

        gamma (float): Discount factor. (Always between 0 and 1.)

        clip_ratio (float): Hyperparameter for clipping in the policy objective.
            Roughly: how far can the new policy go from the old policy while 
            still profiting (improving the objective function)? The new policy 
            can still go farther than the clip_ratio says, but it doesn't help
            on the objective anymore. (Usually small, 0.1 to 0.3.) Typically
            denoted by :math:`\epsilon`. 

        pi_lr (float): Learning rate for policy optimizer.

        vf_lr (float): Learning rate for value function optimizer.

        train_pi_iters (int): Maximum number of gradient descent steps to take 
            on policy loss per epoch. (Early stopping may cause optimizer
            to take fewer than this.)

        train_v_iters (int): Number of gradient descent steps to take on 
            value function per epoch.

        lam (float): Lambda for GAE-Lambda. (Always between 0 and 1,
            close to 1.)

        max_ep_len (int): Maximum length of trajectory / episode / rollout.

        target_kl (float): Roughly what KL divergence we think is appropriate
            between new and old policies after an update. This will get used 
            for early stopping. (Usually small, 0.01 or 0.05.)

        logger_kwargs (dict): Keyword args for EpochLogger.

        save_freq (int): How often (in terms of gap between epochs) to save
            the current policy and value function.

    """

    pid = os.getpid()
    current_process = psutil.Process(pid)
    current_process_memory_usage_as_KB = current_process.memory_info()[0] / 2.**20
    print("BEFORE CODE: Current memory KB   :" +str(current_process_memory_usage_as_KB))
    # Special function to avoid certain slowdowns from PyTorch + MPI combo.
    setup_pytorch_for_mpi()

    '''ntest_batch_size_array = []
    for i in range(len(unit_intest_batch_size_array)):
        intest_batch_size_array.append(unit_intest_batch_size_array[i])
    '''
    # Path setting
    pof_data_path = "/home/user/POF_data_" + str(pof_section) +"/"
    pof_checkpoint_path = pof_data_path + "checkpoints/pof-checkpoint-"+str(pof_checkpoint)+"_epoch-"+str(pof_checkpoint_load_epoch)+".pt"

    # Set up logger and save configuration
    logger = EpochLogger(**logger_kwargs)
    logger.save_config(locals())
    
    
    # Random seed
    seed += 10000 * proc_id()
    torch.manual_seed(seed)
    np.random.seed(seed)

    # Instantiate environment
    env = env_fn()
    obs_dim = env.observation_space.shape #60
    n_observation = obs_dim[0]
    act_dim = env.action_space.shape #2
    
    device = torch.device('cpu')#torch.device("cuda" if torch.cuda.is_available() else "cpu")
    if device.type == 'cuda':
        torch.cuda.manual_seed(seed)
    
    # Create actor-critic module helpmefour
    ac_ppo = actor_critic(env.observation_space, env.action_space, **ac_kwargs)
    ac_ppo.train()
    # ac = actor_critic(env.observation_space, gym.spaces.Discrete(n_translation*n_rotation), **ac_kwargs)

    # Set up optimizers for policy and value function helpmeeight
    pi_lr = 1.5e-5 #241026
    pi_optimizer = Adam(ac_ppo.pi.parameters(), lr=pi_lr)
    penalty_param = torch.tensor(1.0,requires_grad=True).float()
    penalty = Softplus(penalty_param)
    penalty_lr = 2.5e-3 #241026
    penalty_optimizer = Adam([penalty_param], lr=penalty_lr)
    vf_lr = 0.5e-4 #241026
    vf_optimizer = Adam(ac_ppo.v.parameters(), lr=vf_lr)
    cvf_optimizer = Adam(ac_ppo.vc.parameters(),lr=vf_lr)
    kl_coeff = 0.2 #policy.config["kl_coeff"]
    clip_param = 0.2 #policy.config["clip_param"]
    vf_clip_param = 10.0 #policy.config["vf_clip_param"]
    epsilon = 0.01 #policy.config["epsilon"]
    num_barrier_step = 20 #policy.config["num_barrier_step"]
    barrier_lambda = 0.1 #policy.config["barrier_lambda"]
    barrier = core.MLPCritic(obs_dim[0], hidden_sizes=(256,256), activation=nn.Tanh)
    barrier_optimizer = Adam(barrier.parameters(),lr=0.0003)
    logger.setup_pytorch_saver(ac_ppo)
    
    if pof_checkpoint_load_epoch != -1:
        try:
            backup = torch.load(pof_checkpoint_path)
            backup_epoch = backup["epoch"]+1
            ac_ppo.load_state_dict(backup["ac_ppo"])
            pi_optimizer.load_state_dict(backup["pi_optimizer"])
            vf_optimizer.load_state_dict(backup["vf_optimizer"])
            penalty_param = backup["penalty_param"]
            penalty = Softplus(penalty_param)
            penalty_optimizer.load_state_dict(backup["penalty_optimizer"])
            barrier.load_state_dict(backup["barrier"])
            barrier_optimizer.load_state_dict(backup["barrier_optimizer"])
            print("    LOAD CHECKPOINT %s" %(pof_checkpoint_path))
        except Exception as e:
            print(e)
            exit()
    else:
        backup_epoch=0

    # Sync params across processes
    sync_params(ac_ppo)
    if num_procs()!=1:
        p_numpy = penalty_param.data.numpy()
        broadcast(p_numpy)
    sync_params(barrier)
    # Create actor-critic module
    ac_ppo = ac_ppo
    # ac = actor_critic(env.observation_space, gym.spaces.Discrete(n_translation*n_rotation), **ac_kwargs)

    # Count variables
    var_counts = tuple(core.count_vars(module) for module in [ac_ppo.pi, ac_ppo.v])
    logger.log('\nNumber of parameters: \t pi: %d, \t v: %d\n'%var_counts)

    # Set up experience buffer
    local_steps_per_epoch = int(steps_per_epoch / num_procs())
    buf = PPOBuffer(obs_dim, act_dim, local_steps_per_epoch, gamma, lam)
    
    # Set up function for computing PPO policy loss
    def compute_loss_pi(data):
        obs, act, adv, cadv,  logp_old = data['obs'], data['act'], data['adv'], data['cadv'] ,data['logp']
        cur_cost = data['cur_cost']
        penalty_param = data['cur_penalty']
        cost_limit = 0 #float(agent_checkpoint_mode.split('lag')[1]) # 1 2 5 10 15 20 30 50
        # Policy loss
        pi, logp = ac_ppo.pi(obs, act)
        ratio = torch.exp(logp - logp_old)

        clip_adv = torch.clamp(ratio, 1-clip_ratio, 1+clip_ratio) * adv
        loss_rpi = (torch.min(ratio * adv, clip_adv)).mean()

        # clip_cadv = torch.clamp(ratio, 1-clip_ratio, 1+clip_ratio) * cadv
        # loss_cpi = (torch.min(ratio * cadv, clip_cadv)).mean()
        loss_cpi = ratio*cadv
        loss_cpi = loss_cpi.mean()
        
        p = Softplus(penalty_param)
        penalty_param = data['cur_penalty']
        penalty_item = p.item()
      
        pi_objective = loss_rpi - penalty_item*loss_cpi
        pi_objective = pi_objective/(1+penalty_item)
        loss_pi = -pi_objective

        cost_deviation = (cur_cost - cost_limit)

        # Useful extra info
        approx_kl = (logp_old - logp).mean().item()
        ent = pi.entropy().mean().item()
        clipped = ratio.gt(1+clip_ratio) | ratio.lt(1-clip_ratio)
        clipfrac = torch.as_tensor(clipped, dtype=torch.float32).mean().item()
        pi_info = dict(kl=approx_kl, ent=ent, cf=clipfrac)

        return loss_pi, cost_deviation, pi_info

    # Set up function for computing value loss
    def compute_loss_v(data):
        obs, ret, cret = data['obs'], data['ret'], data['cret']
        return ((ac_ppo.v(obs) - ret)**2).mean(),((ac_ppo.vc(obs) - cret)**2).mean()

    # Set up model saving
    # logger.setup_pytorch_saver(ac_ppo)

    def update():
        cur_cost = logger.get_stats('EpCost')[0]
        data = buf.get()
        data['cur_cost'] = cur_cost
        data['cur_penalty'] = penalty_param
        pi_l_old, cost_dev, pi_info_old = compute_loss_pi(data)
        
        #print(penalty_param)
        loss_penalty = -penalty_param*cost_dev

        penalty_optimizer.zero_grad()
        loss_penalty.backward()
        mpi_avg_grads(penalty_param)
        penalty_optimizer.step()
        #print(penalty_param)
        #penalty = softplus(penalty_param)

        data['cur_penalty'] = penalty_param

        pi_l_old = pi_l_old.item()
        v_l_old, cv_l_old = compute_loss_v(data)
        v_l_old, cv_l_old = v_l_old.item(), cv_l_old.item() 
        
        

        # Train policy with multiple steps of gradient descent
        train_pi_iters=80
        for i in range(train_pi_iters):
            pi_optimizer.zero_grad()
            loss_pi, _,pi_info = compute_loss_pi(data)
            kl = mpi_avg(pi_info['kl'])
            if kl > 1.2 * target_kl:
                logger.log('Early stopping at step %d due to reaching max kl.'%i)
                break

            loss_pi.backward()
            mpi_avg_grads(ac_ppo.pi)    # average grads across MPI processes
            pi_optimizer.step()

        logger.store(StopIter=i)

        # Value function learning
        train_v_iters=80
        for i in range(train_v_iters):
            
            loss_v, loss_vc = compute_loss_v(data)
            vf_optimizer.zero_grad()
            loss_v.backward()
            mpi_avg_grads(ac_ppo.v)   # average grads across MPI processes
            vf_optimizer.step()

            cvf_optimizer.zero_grad()
            loss_vc.backward()
            mpi_avg_grads(ac_ppo.vc)
            cvf_optimizer.step()

        # Log changes from update
        kl, ent, cf = pi_info['kl'], pi_info_old['ent'], pi_info['cf']
        logger.store(LossPi=pi_l_old, LossV=v_l_old,
                     KL=kl, Entropy=ent, ClipFrac=cf,
                     DeltaLossPi=(loss_pi.item() - pi_l_old),
                     DeltaLossV=(loss_v.item() - v_l_old))
        
    def new_update():
        data = buf.get()
        obs, act, adv, cadv, logp_old = data['obs'], data['act'], data['adv'], data['cadv'], data['logp']
        crew = data['crew']
        # Policy loss
        certificate = barrier(obs).detach().numpy()
        p = Softplus(penalty_param)
        penalty_margin = np.zeros(1000)
        for i in range(num_barrier_step):
            pm = epsilon * (1 - (1 - barrier_lambda) ** (i + 1)) / \
                    barrier_lambda + certificate[i + 1:] - \
                    (1 - barrier_lambda) ** (i + 1) * certificate[:-i - 1]
            pm = np.clip(pm, 0., None)
            penalty_margin[:-i - 1] = penalty_margin[:-i - 1] + gamma ** i * pm
        penalty_margin = penalty_margin * (1 - gamma) / \
                            (1 - gamma ** num_barrier_step)
        penalty_margin=torch.Tensor(penalty_margin)
        episode_mask = torch.Tensor(np.zeros(1000))
        episode_mask[-1] = 1.0


        if mpi_avg(p.detach().numpy()) <= 2.0:
            penalty_loss = -penalty_param * torch.mean(penalty_margin)
            penalty_optimizer.zero_grad()
            penalty_loss.backward()
            mpi_avg_grads(penalty_param)
            penalty_optimizer.step()
        # else:
        #     penalty_loss = -penalty_param * torch.tensor(0)
        #     penalty_optimizer.zero_grad()
        #     penalty_loss.backward()
        #     mpi_avg_grads(penalty_param)
        
        prev_value_fn_out = ac_ppo.v(obs).detach()
        penalty_margin = (penalty_margin - torch.mean(penalty_margin)) / \
                                torch.max(torch.tensor(1e-4), torch.std(penalty_margin)) # J_Invt_gamma_phi
        train_pi_iters=80
        for m in range(train_pi_iters):
            
            pi, logp = ac_ppo.pi(obs, act)
            ratio = torch.exp(logp - logp_old)

            # Only calculate kl loss if necessary (kl-coeff > 0.0).
            mean_kl_loss = (logp_old - logp).mean().item()

            surrogate_loss = torch.min(
                adv * ratio,
                adv * torch.clamp(
                    ratio, 1 - clip_param,
                                1 + clip_param))
            mean_surrogate_loss = torch.mean(-surrogate_loss) # -J_pi_theta

            mean_surrogate_cost_loss = torch.mean(-ratio * penalty_margin)
            penalty = Softplus(penalty_param).clone() # nu
            mean_policy_loss = (mean_surrogate_loss - penalty * mean_surrogate_cost_loss) / (1 + penalty) #L(nu, theta)
            mean_policy_loss += 0.2 * mean_kl_loss
            
            value_fn_out = ac_ppo.v(obs)
            vf_loss1 = torch.square(value_fn_out -
                                        data['ret'])
            vf_clipped = prev_value_fn_out + torch.clamp(
                value_fn_out - prev_value_fn_out, -vf_clip_param,
                vf_clip_param)
            vf_loss2 = torch.square(vf_clipped -
                                        data['ret'])
            vf_loss = torch.max(vf_loss1, vf_loss2)
            mean_vf_loss = torch.mean(vf_loss) # J_V_w

            certificate = barrier(obs)
            feasible = 1 - crew
            infeasible = crew

            feasible_loss = feasible * torch.max(epsilon + certificate, torch.tensor(0))
            feasible_loss = torch.sum(feasible_loss) / torch.max(torch.sum(feasible), torch.tensor(1)) # J_Edls_phi

            infeasible_loss = infeasible * torch.max(epsilon - certificate, torch.tensor(0))
            infeasible_loss = torch.sum(infeasible_loss) / torch.max(torch.sum(infeasible), torch.tensor(1)) # J_Infs_phi

            invariance_loss = 0
            mask = episode_mask[:-1].type(torch.BoolTensor)
            for i in range(num_barrier_step):
                inv_loss = torch.max(
                    epsilon * (1 - (1 - barrier_lambda) ** (i + 1)) /
                    barrier_lambda + certificate[i + 1:] -
                    (1 - barrier_lambda) ** (i + 1) * certificate[:-i - 1], torch.tensor(0))
                inv_loss = (1 - mask.type(torch.float32)) * inv_loss
                mask = mask[:-1] | mask[1:]
                inv_loss = torch.mean(inv_loss)
                invariance_loss = invariance_loss + gamma ** i * inv_loss
            invariance_loss = invariance_loss * (1 - gamma) / \
                                (1 - gamma ** num_barrier_step) # J_Invt_gamma_phi

            mean_certificate_loss = feasible_loss + infeasible_loss + invariance_loss # J_B_phi

            pi_optimizer.zero_grad()
            mean_policy_loss.backward()
            mpi_avg_grads(ac_ppo.pi)
            pi_optimizer.step()
            
            vf_optimizer.zero_grad()
            mean_vf_loss.backward()
            mpi_avg_grads(ac_ppo.v)
            vf_optimizer.step()
            
            barrier_optimizer.zero_grad()
            mean_certificate_loss.backward()
            mpi_avg_grads(barrier)
            barrier_optimizer.step()
        
        if proc_id() == cpu - 1:
            with open("a.txt", "a") as f: f.write(str(epoch)+" "+str(penalty_param)+" "+str(torch.mean(penalty_margin))+" "+str(mean_policy_loss)+" "+str(mean_vf_loss)+" "+str(mean_certificate_loss)+'\n')

    print("    START NEW SESSION!")
    # Prepare for interaction with environment
    start_time = time.time()
    o, ep_ret,ep_cret, ep_len = env.reset(), 0, 0, 0 
    intest_rejected_count = 0
    
    '''for i in range(n_NN): optimizer_list[i].zero_grad()'''
    
    total_step = 0
    # Main loop: collect experience in env and update/log each epoch
    for epoch in range(backup_epoch, epochs):
        for t in range(local_steps_per_epoch):
            if render and proc_id()==0:
                env.render()

            action_tmp, v, vc, logp_tmp = ac_ppo.step(torch.as_tensor(o, dtype=torch.float32))
            next_state_tmp, reward_tmp, done_tmp, info_tmp = env.step(action_tmp)
            total_step += 1
            cost_tmp = info_tmp.get('cost', 0)
            goal_checking_tmp = info_tmp.get('goal_met')

            buf.store(o, action_tmp, reward_tmp, cost_tmp, v, vc, logp_tmp)
            logger.store(VVals=v)
            logger.store(CVVals=vc)

            if cost_tmp > 0: safety_label_tmp = 1
            else: safety_label_tmp =  0

            o = next_state_tmp
            ep_ret += reward_tmp
            ep_cret += cost_tmp
            ep_len += 1
            if safety_label_tmp == 1: o = env.reset()

            timeout = ep_len == max_ep_len
            terminal_tmp = done_tmp or timeout
            epoch_ended = t==local_steps_per_epoch-1
            if terminal_tmp or epoch_ended:
                if epoch_ended and not(terminal_tmp) and proc_id() == 0:
                    print('Warning: trajectory cut off by epoch at %d steps.'%ep_len, flush=True)
                    
                print("proc#%d: RESET at epoch:%d, local_epoch:%d" %(proc_id(), epoch, t+1))
                if timeout or epoch_ended:
                    next_state_tmp_to_torch = torch.as_tensor(next_state_tmp, dtype=torch.float32)
                    _, v,vc, _ = ac_ppo.step(next_state_tmp_to_torch)
                else:
                    v = 0
                    vc = 0
                buf.finish_path(last_val=v,last_cval=vc)
                if terminal_tmp: logger.store(EpRet=ep_ret, EpLen=ep_len, EpCost=ep_cret)
                o, ep_ret, ep_cret, ep_len = env.reset(), 0, 0, 0
                
        if (epoch % save_freq == 0) and (proc_id() == cpu-1) and (pof_checkpoint != -1):
            torch.save(
                {
                    # main info section
                    "epoch": epoch,
                    # "context": context,
                    # AC section
                    "ac_ppo": ac_ppo.state_dict(),
                    "pi_optimizer": pi_optimizer.state_dict(),
                    "vf_optimizer": vf_optimizer.state_dict(),
                    "penalty_param": penalty_param,
                    "penalty_optimizer": penalty_optimizer.state_dict(),
                    "barrier": barrier.state_dict(),
                    "barrier_optimizer": barrier_optimizer.state_dict()
                    # "cvf_optimizer": cvf_optimizer.state_dict(),
                    # SNN section
                    # "SNN_0": SNN_list[0].state_dict(), #"SNN_1": SNN_list[1].state_dict(), "SNN_2": SNN_list[2].state_dict(), "SNN_3": SNN_list[3].state_dict(), "SNN_4": SNN_list[4].state_dict(), "SNN_5": SNN_list[5].state_dict(),
                    # "Soptim_0": optimizer_list[0].state_dict(), #"Soptim_1": optimizer_list[1].state_dict(), "Soptim_2": optimizer_list[2].state_dict(), "Soptim_3": optimizer_list[3].state_dict(), "Soptim_4": optimizer_list[4].state_dict(), "Soptim_5": optimizer_list[5].state_dict(),
                    # "Ssch_0": scheduler_list[0].state_dict(), #"Ssch_1": scheduler_list[1].state_dict(), "Ssch_2": scheduler_list[2].state_dict(), "Ssch_3": scheduler_list[3].state_dict(), "Ssch_4": scheduler_list[4].state_dict(), "Ssch_5": scheduler_list[5].state_dict(),
                    # "Sschww_0": scheduler_list_with_warmup[0].state_dict(), #"Sschww_1": scheduler_list_with_warmup[1].state_dict(), "Sschww_2": scheduler_list_with_warmup[2].state_dict(), "Sschww_3": scheduler_list_with_warmup[3].state_dict(), "Sschww_4": scheduler_list_with_warmup[4].state_dict(), "Sschww_5": scheduler_list_with_warmup[5].state_dict(),
                    # # internal test case section
                    # "storage_intest_number":storage_intest_number,
                    # "storage_intest_state_list": storage_intest_state_list,
                    # "storage_intest_label_list": storage_intest_label_list,
                    # "safe_intest_index_list": safe_intest_index_list,
                    # "unsafe_intest_index_list": unsafe_intest_index_list,
                    # "current_intest_state_list": current_intest_state_list,
                    # "current_intest_label_list": current_intest_label_list,
                    # "current_intest_size": current_intest_size,
                },
                f"/home/user/POF_data_{pof_section}/checkpoints/pof-checkpoint-{pof_checkpoint}_epoch-{epoch}.pt", pickle_protocol=4
            )
            print("    SAVE CHECKPOINT --- pof-checkpoint-%d_epoch-%d.pt" %(pof_checkpoint, epoch))
            with open("checkpoint_totalenvstep.txt", "a") as f: f.write("TOTAL ENV STEP during epoch" + str(epoch) + ": "+str(total_step)+"\n")

        #update()
        new_update()

        # # Log info about epoch ################################
        logger.log_tabular('Epoch', epoch)
        logger.log_tabular('EpRet', with_min_and_max=True)
        logger.log_tabular('EpCost',with_min_and_max=True)
        logger.log_tabular('EpLen', average_only=True)
        logger.log_tabular('VVals', with_min_and_max=True)
        logger.log_tabular('TotalEnvInteracts', (epoch+1)*steps_per_epoch)
        # logger.log_tabular('LossPi', average_only=True)
        # logger.log_tabular('LossV', average_only=True)
        # logger.log_tabular('DeltaLossPi', average_only=True)
        # logger.log_tabular('DeltaLossV', average_only=True)
        # logger.log_tabular('Entropy', average_only=True)
        # logger.log_tabular('KL', average_only=True)
        # logger.log_tabular('ClipFrac', average_only=True)
        # logger.log_tabular('StopIter', average_only=True)
        logger.log_tabular('Time', time.time()-start_time)
        logger.dump_tabular()


if __name__ == '__main__':
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument('--env', type=str, default='Safexp-PointGoal1-v0')
    parser.add_argument('--hid', type=int, default=256)
    parser.add_argument('--l', type=int, default=2)
    parser.add_argument('--gamma', type=float, default=0.99)
    parser.add_argument('--seed', '-s', type=int, default=0)
    parser.add_argument('--cpu', type=int, default=30)
    parser.add_argument('--steps', type=int, default=4000)
    parser.add_argument('--epochs', type=int, default=50)
    parser.add_argument('--exp_name', type=str, default='ppobarrier_point_checkpoint')
    parser.add_argument('--checkpoint', type=str, default='-1')
    args = parser.parse_args()
    
    mpi_fork(args.cpu)  # run parallel code with mpi

    from utils.run_utils import setup_logger_kwargs
    logger_kwargs = setup_logger_kwargs(args.exp_name, args.seed)
    num_steps = 9e8*args.cpu
    steps_per_epoch = 1000*args.cpu
    epochs = int(num_steps / steps_per_epoch)
    ppo(lambda : gym.make(args.env), actor_critic=core.MLPActorCritic,
        ac_kwargs=dict(hidden_sizes=[args.hid]*args.l), gamma=args.gamma, 
        seed=args.seed, steps_per_epoch=steps_per_epoch, epochs=epochs,
        logger_kwargs=logger_kwargs, ppo_checkpoint=args.checkpoint, cpu=args.cpu)
